" Unit 4 - Lecture 3 "
"------------------------------------------------------------------------"

" Principal Component Analysis "

# Syntax:
princomp(<Data>)


# Creating Multiple Scatter Plots
plot(mtcars[,1:5])

# Correlation Matrix
cor(mtcars[,1:5])


# Proportion of variability explained by each component
model = princomp(mtcars[,1:5])

summary(model)


# Simulation
set.seed(1)
G = data.frame(matrix(runif(100,-10000,
                            10000),
                      nrow = 10))
cor(G)

model.G = princomp(G)
summary(model.G)


# Scree Plot
plot(model,type = "l")



"------------------------------------------------------------------------"

" Correlation Test "

"
Recall:

Pearson's Correlation Coefficient
Spearman's Correlation Coefficient
Kendall's Correlation Coefficient

"

X = 1:50
Y = - exp(X + runif(50,-2,2))

plot(X,Y)

cor(X,Y)
cor(X,Y,method = "spearman")
cor(X,Y,method = "kendall")


"
H0: Rho = 0
H1: Rho != 0
"
cor.test(X,Y,method = "spearman")


"------------------------------------------------------------------------"

" Maximum Likelihood Estimate  "

set.seed(1)
X = rexp(1000,0.25)


"
Steps:

L = prod(f(xi))
log(L) = sum(log(f(xi)))

dlog(L) / dlambda = 0

Note:
f(x)

"

MLE.FUN = function(para){
  
  - sum(log(dexp(X,para)))
  
}


nlm(MLE.FUN,1 / mean(X))

L = seq(0.23,0.25,0.0001)

NLL = c()

for(i in 1:length(L)){
  
  NLL[i] = MLE.FUN(L[i])
  
}


plot(L,NLL)

abline(v = L[which.min(NLL)],
       col = "red")


" For 2 unknown parameters "
set.seed(1)
X = rnorm(1000,5,2)

MLE.FUN = function(para){
  
  - sum(log(dnorm(X,para[1],para[2])))
  
}


nlm(MLE.FUN,c(mean(X),sd(X)))



"------------------------------------------------------------------------"

" Transformation of Variables  "
model = lm(mpg ~ log(wt),mtcars)

mtcars$wt.log = log(mtcars$wt) 
model = glm(mpg ~ wt,
            data = mtcars)

summary(model)


"------------------------------------------------------------------------"
